# scripts/make_per_L_kernels.py
import numpy as np
import os

# Which gauge groups you have kernels for
gauges = ["U1", "SU2", "SU3"]
# The lattice sizes you’ll sweep
Ls = [6, 8, 10, 12]

# Ensure output directory exists
os.makedirs("data/kernels", exist_ok=True)

for gauge in gauges:
    # load the “master” flat kernel
    orig = np.load(f"data/kernels/kernel_{gauge}.npy", allow_pickle=True)
    for L in Ls:
        N = 2 * L * L            # 2·L² links
        resized = np.resize(orig, N)
        out_path = f"data/kernels/kernel_{gauge}_L{L}.npy"
        np.save(out_path, resized)
        print(f"→ {out_path}: {resized.shape[0]} entries")
